Attribute VB_Name = "NCHSFLib"
Option Compare Database
Option Explicit

'NCHSTABS.MDB Clculo de Indicadores Antropomtricos Infantiles
'Gmez de la Torre G, Barclay A, Novara J, Campos MA [ Viper@upch.edu.pe ].
'1986-Sep-12 dBASE (NCHSTABS).
'1991-May-13 NCHSTAB4.PRG Subrutina de clculo individual en XBase.
'1998-Dec-07 NCHSTABS.xls Versin en VBA (Excel 97).
'1999-Jan-24 Versin solo con frmulas (Excel 5/95/97) sin VBA y draft Access 97.
'2000-Jun-02 Versin XLS agrega NHANES 1999+ (US CDC Growth Charts 2000).
'2004-Jul-04 HFA patch, CDC 2000, BMI, single query, functions y portado Acc2002.
'2004-Dic-25 Actualizacin menor (1E-10, extremos) CDC 2000, correccin, interpolacin.
'2007-Abr-07 Adicin de Tablas WHO 2006
'Pendientes:  Nulos,HC,Interfase de Files, CkTNUT & Nulls

'Condiciones
'Libre uso con la sola condicin de citar la fuente.
'Cdigo fuente de implementacin es propiedad intelectual de los autores.
'Tablas de referencia y ajustes polinomiales efectuados por CDC 1979,2000 en dominio pblico.

'Instrucciones
'Colocar en EXDATA el query necesario para extraer los datos de la base original
'(incluir transformaciones de nulos), creando los nombres especficos
'AGE, GENDER, WEIGHT, HEIGHT, METHOD y OEDEMA
'El query PZCData provee el contenido de EXDATA
'y adems columnas con los indicadores segn la Referencia WHO/CDC 1979.
'El query PZC2000 provee el contenido de EXDATA
'y adems columnas con los indicadores segn la Referencia CDC 2000.
'Las letras terminales de los nombres de columna corresponden a:
'   Z   puntaje en unidades Z (Z-Score)
'   P   porcentaje de la mediana de referencia
'   C   percentil correspondiente a Z
'Los nombres de columnas indican el contenido:
'   WA  peso para la edad
'   WH  peso para la talla
'   HA  talla para la edad
'   BM  ndice de masa corporal
'TESTNUT.DBF es un conjunto de datos de prueba, con puntajes calculados por EpiNut CDC.

Function Centile(ZScore As Double) As Double
   ' de codigo Pascal ZPct en EpiInfo V5.0 (MEASURE.PAS, FILES07.EXE)
   Dim tq As Double
   tq = 1 / (1 + 0.2316419 * Abs(ZScore))
   tq = tq * ((((tq * 1.330274429 - 1.821255978) * tq + _
         1.781477937) * tq - 0.356563782) * tq + 0.31938153) * _
         Exp(-ZScore * ZScore / 2) / 2.5066282746
   Centile = 100 * IIf(ZScore < 0, tq, 1 - tq)
  'if Z > 9.985 then ZPct := 99.9
  'if (TempZPct > 99.8) then TempZPct := 99.8
End Function

Function ZScore(XVal As Double, XMean As Double, XSDev As Double) As Double
    ZScore = (XVal - XMean) / Abs((XMean - XSDev) / 1.8807936)
End Function

Function EvalPol(XVal As Double, Knot As Double, P1 As Double, P2 As Double, P3 As Double, P4 As Double) As Double
    EvalPol = P1 + (XVal - Knot) * (P2 + (XVal - Knot) * (P3 + (XVal - Knot) * P4))
End Function

Function InExPol(XX As Double, X0 As Double, XF As Double, Y0 As Double, YF As Double) As Double
    Dim B, M As Double
    InExPol = -99
    If XF <> X0 Then
        M = ((YF - Y0) / (XF - X0))
        B = YF - (M * XF)
        InExPol = (M * XX) + B
    Else
        If YF = Y0 Then
            InExPol = Y0
        End If
    End If
End Function

Function ZAdj3(XVal As Double, Lpar As Single, Mpar As Single, Spar As Single) As Double
    Dim sd3pos, sd23pos, sd3neg, sd23neg As Double
    ZAdj3 = (((XVal / Mpar) ^ Lpar) - 1) / (Spar * Lpar)
    sd3pos = Mpar * ((1 + Lpar * Spar * 3) ^ (1 / Lpar))
    sd23pos = sd3pos - Mpar * ((1 + Lpar * Spar * 2) ^ (1 / Lpar))
    If (ZAdj3 > 3) Then ZAdj3 = 3 + ((XVal - sd3pos) / sd23pos)
    sd3neg = Mpar * ((1 + Lpar * Spar * (-3)) ^ (1 / Lpar))
    sd23neg = Mpar * ((1 + Lpar * Spar * (-2)) ^ (1 / Lpar)) - sd3neg
    If (ZAdj3 < -3) Then ZAdj3 = -3 - ((sd3neg - XVal) / sd23neg)
End Function

'Referencias
' Box GE, Cox DR. An analysis of transformations.
'    J Roy Stat Soc Series B 1964;26:211-252.
' CDCP, NCHS. CDC growth charts: United States.
'    < http://www.cdc.gov/nchs/about/major/nhanes/growthcharts/charts.htm >
'    < http://www.cdc.gov/growthcharts/ >
' Cole TJ. Fitting smoothed centile curves to reference data.
'    J Royal Stat Soc 1988;151:385-418.
' Cole TJ. The LMS method for constructing normalized growth standards.
'    Eur J Clin Nutr 1990;44:45-60.
' Dean AD, Dean JA, Burton AH, Dicker RC. Epi Info Version 5.
'    USD, Inc, Stoen Mountain, GA 1990.
' Dibley MJ, Goldsby JB, Staehling NW, Trowbridge FL.
'    Development of normalized curves for the international growth reference:
'    historical and technical considerations.
'    Am J Clin Nutr 1987 Nov;46(5):736-738.
' Dibley MJ, Staehling N, Nieburg P, Trowbridge FL.
'    Interpretation of Z-score anthropometric indicators derived from the
'    international growth reference.
'    Am J Clin Nutr 1987 Nov;46(5):749-762.
' Flegal KM. Curve smoothing and transformations in the development of growth curves.
'    Am J Clin Nutr 1999 Jul;70(1):163S-5S.
' Gmez de la Torre G, Campos MA, Barclay A. Clculo de Indices Antropomtricos:
'    Una Implementacin en dBASE (NCHSTABS).
'    Lima, Per 1988 Set 12-16: V Jorn Cient/II Jorn Estud UPCH.
' Gueri M, Gurney JM, Jutsum P. The Gomez classification. Time for a change?
'    Bull W H O 1980;58(5):773-777.
' Jordan MD. CASP V3.0. Atlanta, GA, USA: Centers for Disease Control 1986.
' Kuczmarski RJ, Ogden CL, Grummer-Strawn LM, Flegal KM, Guo SS,
'    Wei R, Mei Z, Curtin LR, Roche AF, Johnson CL.
'    CDC growth charts: United States.
'    Advance Data from Vital and Health Statistics of the
'    CCDP/NCHS (314) May 30, 2000.
' Hamill PVV, Drizd Ta, Johnson CZ, Reed RB, Roche AF, Moore WM.
'    Physical growth: National Center for Health Statistics percentiles.
'    Am J Clin Nutr 1979 Mar;32(3):607-629.
' Waterlow JC, Buzina R, Keller W, Lane JM, Nichaman MZ, Tanner JM.
'    The presentation and use of height and weight data for comparing the nutritional status
'    of groups of children under the age of 10 years.
'    Bull W H O 1977;55(4):489-498.
' Ogden CL, Kuczmarski RJ, Flegal KM, Mei Z, Guo S, Wei R, Grummer-Strawn LM, Curtin LR, Roche AF, Johnson CL.
'    Centers for Disease Control and Prevention 2000 growth charts for the United States:
'    improvements to the 1977 National Center for Health Statistics version.
'    Pediatrics 2002 Jan;109(1):45-60.
' WHO Working Group. Use and interpretation of anthropometric indicators of nutritional status.
'    Bull W H O 1986;64(6):929-941.
' WHO Working Group on Infant Growth.
'    An evaluation of infant growth: the use and interpretation of anthropometry in infants.
'    Bull W H O 1995;73(2):165-74.
' SAS. SAS user's guide: statistics. Cary, NC: SAS Institute. 1988.
' Victora CG, Morris SS, Barros FC, de Onis M, Yip R.
'    The NCHS reference and the growth of breast- and bottle-fed infants.
'    J Nutr 1998 Jul;128(7):1134-8.

'Queries obsoletos
'PZData
'SELECT EXDATA.*, 100*EXDATA.Height/RefHFA.HAmdn AS HFAP, 100*EXDATA.Weight/RefWFH.WHmdn AS WFHP, 100*EXDATA.Weight/RefWFA.WAmdn AS WFAP, (EXDATA.Height-RefHFA.HAmdn)/Abs((RefHFA.HAmdn-RefHFA.HAsdn)/1.8807936) AS HFAZ, (EXDATA.Weight-RefWFH.WHmdn)/Abs((RefWFH.WHmdn-RefWFH.WHsdn)/1.8807936) AS WFHZ, (EXDATA.Weight-RefWFA.WAmdn)/Abs((RefWFA.WAmdn-RefWFA.WAsdn)/1.8807936) AS WFAZ
'FROM RefWFH RIGHT JOIN (RefWFA RIGHT JOIN (EXDATA LEFT JOIN RefHFA ON EXDATA.IDNUM = RefHFA.IDNUM) ON RefWFA.IDNUM = EXDATA.IDNUM) ON RefWFH.IDNUM = EXDATA.IDNUM;
'
'RefHFA
'SELECT EXDATA.IDNUM, NCHSCOEC.PCOEF1+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF2+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF3+(EXDATA.Age-NCHSCOEC.KNOT)*NCHSCOEC.PCOEF4)) AS HAmdn, Iif(EXDATA.Height<NCHSCOEC.PCOEF1+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF2+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF3+(EXDATA.Age-NCHSCOEC.KNOT)*NCHSCOEC.PCOEF4)),NCHSCOEC.LCOEF1+(EXDATA.Age-NCHSCOEC.KNOT+IIf(NCHSCOEC.RECPOS=51,30,0))*(NCHSCOEC.LCOEF2+(EXDATA.Age-NCHSCOEC.KNOT+IIf(NCHSCOEC.RECPOS=51,30,0))*(NCHSCOEC.LCOEF3+(EXDATA.Age-NCHSCOEC.KNOT+IIf(NCHSCOEC.RECPOS=51,30,0))*NCHSCOEC.LCOEF4)), NCHSCOEC.RCOEF1+(EXDATA.Age-NCHSCOEC.KNOT+IIf(NCHSCOEC.RECPOS=52,6,0))*(NCHSCOEC.RCOEF2+(EXDATA.Age-NCHSCOEC.KNOT+IIf(NCHSCOEC.RECPOS=52,6,0))*(NCHSCOEC.RCOEF3+(EXDATA.Age-NCHSCOEC.KNOT+IIf(NCHSCOEC.RECPOS=52,6,0))*NCHSCOEC.RCOEF4))) AS HAsdn
'FROM EXDATA, NCHSCOEC
'WHERE (((NCHSCOEC.TABCONT)="HFA") AND ((NCHSCOEC.UNDER25)=EXDATA.Method) AND ((NCHSCOEC.XRSEX)=EXDATA.Gender) AND ((NCHSCOEC.KNOTTOP)>EXDATA.Age) AND ((NCHSCOEC.KNOTBOT)<=EXDATA.Age));
'
'RefWFA
'SELECT EXDATA.IDNUM, NCHSCOEC.PCOEF1+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF2+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF3+(EXDATA.Age-NCHSCOEC.KNOT)*NCHSCOEC.PCOEF4)) AS WAmdn, Iif(EXDATA.Weight<NCHSCOEC.PCOEF1+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF2+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF3+(EXDATA.Age-NCHSCOEC.KNOT)*NCHSCOEC.PCOEF4)),NCHSCOEC.LCOEF1+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.LCOEF2+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.LCOEF3+(EXDATA.Age-NCHSCOEC.KNOT)*NCHSCOEC.LCOEF4)), NCHSCOEC.RCOEF1+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.RCOEF2+(EXDATA.Age-NCHSCOEC.KNOT)*(NCHSCOEC.RCOEF3+(EXDATA.Age-NCHSCOEC.KNOT)*NCHSCOEC.RCOEF4))) AS WAsdn
'FROM EXDATA, NCHSCOEC
'WHERE (((NCHSCOEC.TABCONT)="WFA") AND ((NCHSCOEC.UNDER25)=EXDATA.Method) AND ((NCHSCOEC.XRSEX)=EXDATA.Gender) AND ((NCHSCOEC.KNOTTOP)>EXDATA.Age) AND ((NCHSCOEC.KNOTBOT)<=EXDATA.Age));
'
'RefWFH
'SELECT EXDATA.IDNUM, NCHSCOEC.PCOEF1+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF2+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF3+(EXDATA.Height-NCHSCOEC.KNOT)*NCHSCOEC.PCOEF4)) AS WHmdn, Iif(EXDATA.Weight<NCHSCOEC.PCOEF1+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF2+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.PCOEF3+(EXDATA.Height-NCHSCOEC.KNOT)*NCHSCOEC.PCOEF4)),NCHSCOEC.LCOEF1+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.LCOEF2+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.LCOEF3+(EXDATA.Height-NCHSCOEC.KNOT)*NCHSCOEC.LCOEF4)), NCHSCOEC.RCOEF1+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.RCOEF2+(EXDATA.Height-NCHSCOEC.KNOT)*(NCHSCOEC.RCOEF3+(EXDATA.Height-NCHSCOEC.KNOT)*NCHSCOEC.RCOEF4))) AS WHsdn
'FROM EXDATA, NCHSCOEC
'WHERE (((NCHSCOEC.TABCONT)="WFH") AND ((NCHSCOEC.UNDER25)=EXDATA.Method) AND ((NCHSCOEC.XRSEX)=EXDATA.Gender) AND ((NCHSCOEC.KNOTTOP)>EXDATA.Height) AND ((NCHSCOEC.KNOTBOT)<=EXDATA.Height));

'importacin de datos CDC 2000
'
'Query1
'SELECT "WA" AS ITAB, 1 AS IRECUMB, SEX AS ISEX, AGEDAYS2 AS ICOOX, L AS LPAR, M AS MPAR, S AS SPAR
'FROM wazlms
'UNION ALL
'SELECT "HA" AS ITAB, 1 AS IRECUMB, SEX AS ISEX, AGEDAYS2 AS ICOOX, L AS LPAR, M AS MPAR, S AS SPAR
'FROM hazlms
'UNION ALL
'SELECT "WH" AS ITAB, 1 AS IRECUMB, SEX AS ISEX, LENGTH2 AS ICOOX, L AS LPAR, M AS MPAR, S AS SPAR
'FROM wfllms
'UNION ALL
'SELECT "WH" AS ITAB, 2 AS IRECUMB, SEX AS ISEX, HEIGHT2 AS ICOOX, L AS LPAR, M AS MPAR, S AS SPAR
'FROM wfhlms
'UNION ALL SELECT "BM" AS ITAB, 1 AS IRECUMB, SEX AS ISEX, AGEDAYS2 AS ICOOX, L AS LPAR, M AS MPAR, S AS SPAR
'FROM bmilms;
'
'Query 2
'INSERT INTO WHO2006 ( ITAB, IRECUMB, ISEX, ICOOX, LPAR, MPAR, SPAR )
'SELECT Query1.ITAB, Query1.IRECUMB, Query1.ISEX, Query1.ICOOX, Query1.LPAR, Query1.MPAR, Query1.SPAR
'FROM Query1;

'importacin de datos WHO 2006
'INSERT INTO WHO2006 ( ITAB, IRECUMB, ISEX, ICOOX, LPAR, MPAR, SPAR )
'SELECT "BM" AS ITAB, 1 AS IRECUMB, RF.SEX AS ISEX, RF.AGEDAYS2 AS ICOOX, RF.L AS LPAR, RF.M AS MPAR, RF.S AS SPAR
'FROM bmilms AS RF;
'INSERT INTO WHO2006 ( ITAB, IRECUMB, ISEX, ICOOX, LPAR, MPAR, SPAR )
'SELECT "HA" AS ITAB, 1 AS IRECUMB, RF.SEX AS ISEX, RF.AGEDAYS2 AS ICOOX, RF.L AS LPAR, RF.M AS MPAR, RF.S AS SPAR
'FROM hazlms AS RF;
'INSERT INTO WHO2006 ( ITAB, IRECUMB, ISEX, ICOOX, LPAR, MPAR, SPAR )
'SELECT "WA" AS ITAB, 1 AS IRECUMB, RF.SEX AS ISEX, RF.AGEDAYS2 AS ICOOX, RF.L AS LPAR, RF.M AS MPAR, RF.S AS SPAR
'FROM wazlms AS RF;
'INSERT INTO WHO2006 ( ITAB, IRECUMB, ISEX, ICOOX, LPAR, MPAR, SPAR )
'SELECT "WH" AS ITAB, 1 AS IRECUMB, RF.SEX AS ISEX, RF.LENGTH2 AS ICOOX, RF.L AS LPAR, RF.M AS MPAR, RF.S AS SPAR
'FROM wfllms AS RF;
'INSERT INTO WHO2006 ( ITAB, IRECUMB, ISEX, ICOOX, LPAR, MPAR, SPAR )
'SELECT "WH" AS ITAB, 2 AS IRECUMB, RF.SEX AS ISEX, RF.HEIGHT2 AS ICOOX, RF.L AS LPAR, RF.M AS MPAR, RF.S AS SPAR
'FROM wfhlms AS RF;

'********    WHO Child Growth Standards                                                            ***.
'********    Department of Nutrition for Health and Development                                    ***.
'********    World Health Organization                                                             ***.
'********    Last modified on 27/09/2006     -     For SPSS versions 6.0 and above                 ***.
'* ==================declare flagged values missing=========================.
'if (oedema='y' or oedema='Y') zwhz=-4.44.
'if (oedema='y' or oedema='Y') zwaz=-4.44.
'if (oedema='y' or oedema='Y') zbmi=-4.44.
'if (zwhz < -5 or zwhz >5 ) zwhz =999.99.
'if (zhaz < -6 or zhaz >6 ) zhaz =999.99.
'if (zwaz < -6 or zwaz >5 ) zwaz =999.99.
'if (zbmi < -5 or zbmi >5) zbmi=999.99.
'* we copy the zscores to oedema copies for special oedema adjustments later.
'*Now that prevalences are done, we declare oedema z's of -4.44 as missing.
'*get rid of zbmi=-4.44 with oedema so it is not calculated in mean zbmi.
'*so we can use these z variables for means, & the oedz's for prevalences & N.
'If (zbmi=-4.44 and (oedema='y' or oedema='Y'))zbmi=888.
'If (zwhz=-4.44 and (oedema='y' or oedema='Y'))zwhz=888.
'If (zwaz=-4.44 and (oedema='y' or oedema='Y'))zwaz=888.
'MISSING VALUES zbmi, zwhz,zwaz, zhaz (999.99, 888).

